<?php
/**
 * Plugin Name:          Wordfence Scan Results API Connector
 * Description:          Цей плагін надає API-інтерфейс для отримання результатів сканування безпеки Wordfence. Плагін повертає актуальні результати перевірок, що дає змогу здійснювати моніторинг загроз на сайті. Підтримує обмеження доступу за API-ключем.
 * Version:              0.2.6
 * Network:              true
 * Author:               GoFix team
 * License:              GPL v2 or later
 * License URI:          https://www.gnu.org/licenses/gpl-2.0.html
 **/

defined('ABSPATH') || exit('403 Forbidden');
define('WF_API_PLUGIN_VERSION', '0.2.6');
define('WF_API_PLUGIN_SLUG', 'wf-api');
define('WF_API_TRANSIENT_KEY', 'wf_api_upgrade_' . WF_API_PLUGIN_SLUG);
if (!defined('WF_API_PLUGIN_DIR')) {
    define('WF_API_PLUGIN_DIR', plugin_dir_path(__FILE__));
}
if (!defined('WF_API_PLUGIN_FILE')) {
    define('WF_API_PLUGIN_FILE', __FILE__);
}
define('WF_API_PLUGIN_UPGRADE_SERVER', 'http://ensico.biz.ua');

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
include_once( WF_API_PLUGIN_DIR . 'helpers/helpers.php' );

if (is_admin()) {
    require_once WF_API_PLUGIN_DIR . 'includes/admin.php';
} else {
    require_once WF_API_PLUGIN_DIR . 'includes/main.php';
}


// Automatic updates @ based on:
//    https://www.jasom.net/custom-wordpress-plugin-repository/
//    https://rudrastyh.com/wordpress/self-hosted-plugin-update.html
if (is_admin()) {
    /**
     * @return false|array|WP_Error
     */
    function wf_api_get_plugin_info() {
        // trying to get from cache first, to disable cache comment transient related lines
        $remote = get_transient(constant('WF_API_TRANSIENT_KEY'));
        if (false === $remote) {
            // info.json is the file with the actual information about plug-in on your server
            $remote = wp_remote_get(
                constant('WF_API_PLUGIN_UPGRADE_SERVER') . '/info.json',
                [
                    'timeout' => 10,
                    'headers' => ['Accept' => 'application/json'],
                ]
            );

            if (
                !is_wp_error($remote)
                && is_array($remote)
                && isset($remote['response']['code'])
                && $remote['response']['code'] === 200
                && !empty($remote['body'])
            ) {
                set_transient(constant('WF_API_TRANSIENT_KEY'), $remote, 21600); // 6 hours cache
            }
        }

        return $remote;
    }

    /**
     * Pop-up with details about plugin update visible when there is a new release
     */
    function wf_api_plugin_info($res, $action, $args)
    {
        // do nothing if this is not about getting plugin information
        if ($action !== 'plugin_information') {
            return false;
        }

        // do nothing if it is not our plugin
        if (constant('WF_API_PLUGIN_SLUG') !== $args->slug) {
            return $res;
        }

        $pluginInfo = wf_api_get_plugin_info();
        if (is_wp_error($pluginInfo)) {
            return false;
        }

        $responseData = json_decode($pluginInfo['body']);
        if (!$responseData) {
            return false;
        }

        $res = new stdClass();
        $res->name = $responseData->name;
        $res->slug = $responseData->slug;
        $res->version = $responseData->version;
        $res->tested = $responseData->tested;
        $res->requires = $responseData->requires;
        $res->author = $responseData->author;
        $res->author_profile = isset($responseData->author_homepage) ? $responseData->author_homepage : null;
        $res->download_link = $responseData->download_link;
        $res->trunk = $responseData->download_link;
        $res->last_updated = $responseData->last_updated;
        $res->sections = array(
            'description' => $responseData->sections->description, // description tab
            // 'installation' => $responseData->sections->installation, // installation tab
            // you can add your custom sections (tabs) here like 'changelog'
        );
        /* TODO add them ?..
        $res->banners = array(
            'low' => $responseData->banners->low,
            'high' => $responseData->banners->high,
        );
        */

        return $res;
    }

    add_filter('plugins_api', 'wf_api_plugin_info', 20, 3);


    /**
     * Push update itself for plugin or theme
     */
    function wf_api_push_update($transient)
    {
        if (empty($transient->checked)) {
            return $transient;
        }

        $pluginInfo = wf_api_get_plugin_info();
        if (!$pluginInfo || is_wp_error($pluginInfo)) {
            return $transient;
        }

        $responseData = json_decode($pluginInfo['body']);
        if (!$responseData) {
            return $transient;
        }

        // your installed plugin version should be on the line below! You can obtain it dynamically of course
        if (
            version_compare(constant('WF_API_PLUGIN_VERSION'), $responseData->version, '<')
            && version_compare($responseData->requires, get_bloginfo('version'), '<')
        ) {
            $res = new stdClass();
            $res->slug = constant('WF_API_PLUGIN_SLUG');
            $res->plugin = constant('WF_API_PLUGIN_SLUG') . '/' . constant('WF_API_PLUGIN_SLUG') . '.php';
            $res->new_version = $responseData->version;
            $res->tested = $responseData->tested;
            $res->package = $responseData->download_link;
            $transient->response[$res->plugin] = $res;
            // TODO do we need the line below ?..
            //$transient->checked[$res->plugin] = $responseData->version;
        }

        return $transient;
    }

    add_filter('site_transient_update_plugins', 'wf_api_push_update');


    /**
     * Cache the results to make update process fast
     */
    function wf_api_after_update($upgrader_object, $options)
    {
        if ($options['action'] === 'update' && $options['type'] === 'plugin') {
            // just clean the cache when new plugin version is installed
            delete_transient(constant('WF_API_TRANSIENT_KEY'));
        }
    }

    add_action('upgrader_process_complete', 'wf_api_after_update', 10, 2);
}
