<?php

defined('ABSPATH') || exit('403 Forbidden');

// Prevents execution if it wasn't requested
if (!isset ($_POST['wf_api_command']) || !isset ($_POST['wf_api_key'])) {
    return; // this file would only be included; "return" would stop execution of the included file
}

$wf_api_data = [];

function wf_api_get_plugin_issues() {
	global $wpdb;

	$last_scan_date = null;
	$current_time   = time();
	$week_ago       = strtotime( '-7 days' );

	$wf_config_table_lowercase = $wpdb->prefix . 'wfconfig';
	$wf_config_table_camelcase = $wpdb->prefix . 'wfConfig';

	$wf_issues_table_lowercase = $wpdb->prefix . 'wfissues';
	$wf_issues_table_camelcase = $wpdb->prefix . 'wfIssues';

	if ( wordfence_table_exists( $wf_config_table_lowercase ) && wordfence_table_exists( $wf_issues_table_lowercase ) ) {
		$wf_config_table = $wf_config_table_lowercase;
		$wf_issues_table = $wf_issues_table_lowercase;
	} elseif ( wordfence_table_exists( $wf_config_table_camelcase ) && wordfence_table_exists( $wf_issues_table_camelcase ) ) {
		$wf_config_table = $wf_config_table_camelcase;
		$wf_issues_table = $wf_issues_table_camelcase;
	} else {
		return [ 'error' => 'WordFence DB tables not found, or plugin is not installed' ];
	}

    $last_scan_date_db = $wpdb->get_results('SELECT val FROM `' . $wf_config_table . '` WHERE name="scanMonitorLastSuccess"');

	foreach ($last_scan_date_db as $item){
        foreach ($item as $value){
            $last_scan_date = $value;
        }
    }

    if (!$last_scan_date) {
	    $wf_api_data = [
		    [
			    'id'          => 999,
			    'time'        => $current_time,
			    'status'      => 'new',
			    'type'        => 'wfNoScan',
			    'severity'    => 75,
			    'shortMsg'    => 'No Wordfence Scan.',
			    'longMsg'     => 'There were no scan of website by Wordfence plugin.',
		    ],
	    ];
    } elseif ($last_scan_date < $week_ago) {
	    $last_scan_normal_format = date( 'd-m-Y H:i:s', $last_scan_date );

		$wf_api_data = [
		    [
			    'id'                       => 999,
			    'time'                     => $current_time,
			    'lastUpdated'              => $last_scan_date,
			    'lastScanDateNormalFormat' => $last_scan_normal_format,
			    'status'                   => 'new',
			    'type'                     => 'wfOutdatedScan',
			    'severity'                 => 75,
			    'shortMsg'                 => 'Outdated Wordfence Scan.',
			    'longMsg'                  => 'The latest scan of Wordfence plugin was long time ago: ' . $last_scan_normal_format,
		    ],
	    ];
    } else {
        $wf_api_data = $wpdb->get_results('SELECT * FROM `' . $wf_issues_table . '`');

		foreach ( $wf_api_data as &$row ) {
		    $updated_data = [];

		    foreach ( $row as $key => $value ) {
			    $updated_data[ $key ] = $value;

			    if ( $key === 'lastUpdated' ) {
				    $updated_data['lastScanDateNormalFormat'] = date( 'd-m-Y H:i', $value );
			    }
		    }

		    $row = $updated_data;
	    }

        $admins_without_mfa  = get_admins_without_mfa();

        if ( $admins_without_mfa ) {
            $wf_api_data[] = $admins_without_mfa;
        }

        if (is_null($wf_api_data)) {
            $wf_api_data = ['error' => 'WPDB query returned null'];
        }
    }
    return $wf_api_data;
}

function wf_api_get_system_info() {
	$installed_plugins = get_installed_plugins();
	$installed_themes  = get_installed_themes();

	return [
		'php_version'       => phpversion(),
		'wordpress_version' => get_bloginfo( 'version' ),
		'installed_plugins' => $installed_plugins,
		'installed_themes'  => $installed_themes,
	];
}

// Checks API key
if (!$_POST['wf_api_key'] || get_option('wf_api_key') !== $_POST['wf_api_key']) {
    $wf_api_data = ['error' => 'Incorrect API key'];
} else {
    // Proccess API commands
    switch ($_POST['wf_api_command']) {
        case 'list':
			$wf_api_data = wf_api_get_plugin_issues();
			break;
	    case 'system_info':
			$wf_api_data = wf_api_get_system_info();
			break;
        default:
            $wf_api_data = ['error' => 'Unknown API command'];
			break;
    }
}

header('Content-type: application/json');
echo json_encode($wf_api_data);
exit();
