<?php

defined('ABSPATH') || exit('403 Forbidden');

if ( is_multisite() ) {
	add_action( 'network_admin_menu', 'add_settings_page' );
} else {
	add_action( 'admin_menu', 'add_settings_page' );
}

function add_settings_page() {
	add_menu_page(
		'WF APIs',
		'WF API',
		'manage_options',
		'wf_api',
		'wf_api_options_page'
	);
}

add_action(
    'init',
    function () {
        $wf_api_key = get_option('wf_api_key');
        if (!$wf_api_key || (isset($_POST['wf_api_key_regenerate']) && $_POST['wf_api_key_regenerate'])) {
            // CSRF protection
            if (
                isset($_POST['wf_api_admin_nonce'])
                && wp_verify_nonce(
                    sanitize_text_field(wp_unslash($_POST['wf_api_admin_nonce'])),
                    'wf_api_admin'
                )
            ) {
                if (function_exists('random_bytes')) {
                    $wf_api_key = bin2hex(random_bytes(32));
                } else {
                    $wf_api_key = md5(time());
                }

                update_option('wf_api_key', $wf_api_key);
                add_action(
                    'admin_notices',
                    function () {
                        echo sprintf(
                            '<div class="notice notice-success is-dismissible"><p>%s</p></div>',
                            esc_html__('Новий API-ключ згенеровано!', 'wf_api_admin')
                        );
                    }
                );
            } elseif (isset($_POST['wf_api_key_regenerate'])) {
                add_action(
                    'admin_notices',
                    function () {
                        echo sprintf(
                            '<div class="notice notice-error is-dismissible"><p>%s</p></div>',
                            esc_html__(
                                'Не вдалось згенерувати новий API-ключ. Будь ласка, спробуйте ще раз.',
                                'wf_api_admin'
                            )
                        );
                    }
                );
            }
        }
    }
);

function wf_api_options_page()
{
    $wf_api_key = get_option('wf_api_key');
    ?>
    <div class="wrap">
        <h1>WordFence API</h1>
        <br/>
        <form method="POST">
            <strong>API-ключ</strong> <input type="text" value="<?= htmlspecialchars($wf_api_key, ENT_QUOTES) ?>"
                                             autofocus readonly class="regular-text code"
                                             onclick="this.setSelectionRange(0, this.value.length)"/> <input
                    type="hidden" name="wf_api_key_regenerate" value="1"/> <input type="submit"
                                                                                  value="Згенерувати новий ключ"
                                                                                  class="button button-primary"/><?php
            wp_nonce_field('wf_api_admin', 'wf_api_admin_nonce'); ?>
        </form>
        <br/>
        Будь ласка, генеруйте нові ключі лише в разі необхідності.
    </div>
<?php
}
